///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the Void Format exporter plug-in for Flexporter.
 *	\file		VoidExporter.h
 *	\author		Pierre Terdiman
 *	\date		May, 6, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __VOIDEXPORTER_H__
#define __VOIDEXPORTER_H__


	class VoidFormat : public ExportFormat
	{
	public:
	// Constructor/Destructor
										VoidFormat();
		virtual							~VoidFormat();

	// Exporter init
		virtual	bool					Init(bool motion);

	// Main scene info
		virtual bool					SetSceneInfo(const MainDescriptor& maininfo);

	// Export loop
    virtual bool          ExportBasicInfo(const ObjectDescriptor* obj);
		virtual bool					ExportCamera		(const CameraDescriptor& camera);
		virtual bool					ExportController	(const ControllerDescriptor& controller);
		virtual bool					ExportHelper		(const HelperDescriptor& helper);
		virtual bool					ExportLight			(const LightDescriptor& light);
		virtual bool					ExportMaterial		(const MaterialDescriptor& material);
		virtual bool					ExportMesh			(const MeshDescriptor& mesh);
		virtual bool					ExportMotion		(const MotionDescriptor& motion);
		virtual bool					ExportShape			(const ShapeDescriptor& shape);
		virtual bool					ExportTexture		(const TextureDescriptor& texture);


	// End of export notification
		virtual bool					EndExport(const StatsDescriptor& stats);

	private:
    FILE*             m_f;
    MAXTimeInfo				    mTimeInfo;
	};

#endif // __VOIDEXPORTER_H__
